<?php

/**
 * Provides local storage for authentication server's public key
 */
class KeyStorage implements \IAI\Application\PublicKeyStorageInterface
{
    const KEY_PATH = '/assets/public.key';

    /**
     * {@inheritdoc}
     */
    public function store($key)
    {
        file_put_contents($this->getKeyLocation(), $key);
    }

    /**
     * {@inheritdoc}
     */
    public function retrieve()
    {
        $keyLocation = $this->getKeyLocation();

        if (file_exists($keyLocation)) {
            $contents = file_get_contents($keyLocation);
            if (!empty($contents)) {
                return $contents;
            }
        }

        return null;
    }

    /**
     * Returns public key location
     *
     * @return string
     */
    protected function getKeyLocation()
    {
        return __DIR__ . self::KEY_PATH;
    }

}