<?php

use \League\OAuth2\Client\Token\AccessToken;

/**
 * Keeps current state of application - wraps up $_SESSION and implements required StateInterface
 */
class ApplicationState implements IAI\Application\StateInterface
{
    /**
     * {@inheritdoc}
     */
    public function setState($state)
    {
        $_SESSION['application_state'] = $state;
    }

    /**
     * {@inheritdoc}
     */
    public function getCurrentState()
    {
        return $_SESSION['application_state'];
    }

    /**
     * {@inheritdoc}
     */
    public function createAuthenticationStateString()
    {
        return bin2hex(random_bytes(31));
    }

    /**
     * Checks if user is logged in
     *
     * @return bool
     */
    public function isLoggedIn()
    {
        return !empty($_SESSION['user']);
    }

    /**
     * Sets user in session
     *
     * @param stdClass $user
     */
    public function setUser($user)
    {
        $_SESSION['user'] = $user;
    }

    /**
     * Gets user from session
     *
     * @return stdClass
     */
    public function getUser()
    {
        return $_SESSION['user'];
    }

    /**
     * Saves token in session
     *
     * @param AccessToken $token
     */
    public function setToken(AccessToken $token)
    {
        $_SESSION['token'] = $token;
    }

    /**
     * Returns token from session
     *
     * @return AccessToken
     *
     * @throws RuntimeException when there is no token saved in session
     */
    public function getToken()
    {
        if (empty($_SESSION['token'])) {
            throw new RuntimeException('No token');
        }

        return $_SESSION['token'];
    }

    /**
     * Checks if access token is still valid
     *
     * @return bool
     * 
     * @throws RuntimeException when there is no token saved in session or token has no expire time
     */
    public function hasToRefreshToken()
    {
        return $this->getToken()->hasExpired();
    }
}