<?php

namespace IAI\Application;

/**
 * Class representing application configuration
 */
class Config
{
    /**
     * IAI Panel's technical domain
     *
     * @var string
     */
    private $panelTechnicalDomain;

    /**
     * Application ID (client_id)
     *
     * @var string
     */
    private $id;

    /**
     * Application secret (client_secret)
     *
     * @var string
     */
    private $secret;

    /**
     * URI to redirect to after authentication
     *
     * @var string
     */
    private $redirectUri;

    /**
     * Sets IAI Panel's technical domain
     *
     * @return string
     */
    public function getPanelTechnicalDomain()
    {
        return $this->panelTechnicalDomain;
    }

    /**
     * Gets IAI Panel's technical domain
     *
     * @param string $panelTechnicalDomain
     *
     * @return Config
     */
    public function setPanelTechnicalDomain($panelTechnicalDomain)
    {
        $this->panelTechnicalDomain = $panelTechnicalDomain;

        return $this;
    }

    /**
     * Gets application ID (client_id)
     *
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Sets application ID (client_id)
     *
     * @param string $id
     *
     * @return Config
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Gets application secret (client_secret)
     *
     * @return string
     */
    public function getSecret()
    {
        return $this->secret;
    }

    /**
     * Sets application secret (client_secret)
     *
     * @param string $secret
     *
     * @return Config
     */
    public function setSecret($secret)
    {
        $this->secret = $secret;

        return $this;
    }

    /**
     * Gets URI to redirect to after authentication
     *
     * @return string
     */
    public function getRedirectUri()
    {
        return $this->redirectUri;
    }

    /**
     * Sets URI to redirect to after authentication
     *
     * @param string $redirectUri
     *
     * @return Config
     */
    public function setRedirectUri($redirectUri)
    {
        $this->redirectUri = $redirectUri;

        return $this;
    }
}