<?php
/*
 * @license     GPLv2 or later http://www.gnu.org/licenses/gpl-2.0.html
 */
defined('_JEXEC') or die;

/**
 * Class IdoSellBookingWidgetModelWidget
 *
 * klasa obslugujaca plugin
 */
class plgContentIdoSellBookingWidget extends JPlugin
{
    /**
     * wyszukuje w przekazanym tekscie tagi IdoSell Booking Widget i zaminia je na widget/przycisk
     */
    function onContentPrepare($context, &$article, &$params, $page = 0)
    {
        $pattern1 = '/\{idosellbookingwidget\|button\}(.*?)\{\/idosellbookingwidget\}/i';
        $pattern2 = '/\{idosellbookingwidget\|widget(\|(\d*))?\/\}/i';

        jimport('joomla.application.component.model');
        JModelLegacy::addIncludePath(JPATH_SITE . '/components/com_idosellbookingwidget/models');

        $bookingWidgetComponentModel = JModelLegacy::getInstance('Widget', 'IdoSellBookingWidgetModel');
        JFactory::getDocument()->addScript($bookingWidgetComponentModel->getIdoSellBookingWidgetJsPath());

        $text = $article->text;

        $text = preg_replace_callback($pattern1, 'insertButton', $text);
        $text = preg_replace_callback($pattern2, 'insertWidget', $text);

        $article->text = $text;

        return true;
    }
}

function insertWidget($matches)
{
    $match = null;
    if (isset($matches[2])) {
        $match = $matches[2];
    }
    if (!$match || $match == '') {
        $match = null;
    }
    $widgetCode = JModelLegacy::getInstance('Widget', 'IdoSellBookingWidgetModel')->getWidgetCode($match);
    return $widgetCode;
}

function insertButton($matches)
{
    $bookingWidgetComponentModel = JModelLegacy::getInstance('Widget', 'IdoSellBookingWidgetModel');
    $match = $matches[1];
    if (!$match || $match == '') {
        $match = null;
    }
    $buttonCode = $bookingWidgetComponentModel->getButtonCode((bool)$match,$match);
    return $buttonCode;
}

?>