<?php
/*
 * @license     GPLv2 or later http://www.gnu.org/licenses/gpl-2.0.html
 */
defined('_JEXEC') or die('Restricted access');

/**
 * Class IdoSellBookingWidgetModelWidget
 *
 * klasa zawierajaca metody obslugujace generowanie widgetu/buttonow IdoSell Booking
 */
class IdoSellBookingWidgetModelWidget extends JModelItem
{
    const BOOKING_WIDGET_SETTING_SHOW_DEMO = 'show_booking_demo';
    const BOOKING_WIDGET_SETTING_BOOKING_ID = 'booking_id';
    const BOOKING_WIDGET_SETTING_YES = 'yes';
    const BOOKING_WIDGET_SETTING_NO = 'no';
    const BOOKING_WIDGET_DEMO_ID = 4835;
    protected $message;

    /**
     * pobiera dane ustawienie
     *
     * @param string $name
     *
     * @return int|mixed
     */
    protected function getIdoSellBookingWidgetSetting($name)
    {
        if (self::BOOKING_WIDGET_SETTING_BOOKING_ID == $name && self::BOOKING_WIDGET_SETTING_YES == $this->getIdoSellBookingWidgetSetting(self::BOOKING_WIDGET_SETTING_SHOW_DEMO)) {
            // jeśli mamy wyświetlać demo systemu korzystamy z panelu 4835
            return self::BOOKING_WIDGET_DEMO_ID;
        }

        $db = JFactory::getDbo();
        $query = $db->getQuery(true)
            ->select($db->quoteName(array('value')))
            ->from($db->quoteName('#__idosellbookingwidget_settings'))
            ->where($db->quoteName('name')." = ".$db->quote($name));
        $db->setQuery($query);

        $value = $db->loadResult();
        return $value;
    }

    /**
     * generuje url dla js
     *
     * @return string
     */
    public function getIdoSellBookingWidgetJsPath()
    {
        $bookingId = $this->getIdoSellBookingWidgetSetting('booking_id');
        $jsPath = 'https://client' . $bookingId . '.idosell.com/widget/script/loadScriptsForCms';
        return $jsPath;
    }

    /**
     * generuje html przycisku wyswietlajacego widget
     *
     * @param bool $showButtonAlternativeText
     * @param string $buttonText
     *
     * @return string
     */
    public function getButtonCode($showButtonAlternativeText = null, $buttonText = null)
    {
        $lang = JFactory::getLanguage();
        $lang->load('com_idosellbookingwidget', JPATH_ROOT);
        $panelId = $this->getIdoSellBookingWidgetSetting('booking_id');
        if (!$panelId) {
            return JText::_( 'COM_IDOSELLBOOKINGWIDGET_NIE_OKRESLONO_ID_PANELU' );
        }
        if (!$showButtonAlternativeText) {
            $buttonText = $this->getIdoSellBookingWidgetSetting('button_standard_text');
            if (!$buttonText) {
                return JText::_( 'COM_IDOSELLBOOKINGWIDGET_NIE_OKRESLONO_TEKSTU_WYSWIETLANEGO_NA_PRZYCISKU' );
            }
        } else {
            if (!$buttonText) {
                return JText::_( 'COM_IDOSELLBOOKINGWIDGET_NIE_OKRESLONO_TEKSTU_WLASNEGO_WYSWIETLANEGO_NA_PRZYCISKU' );
            }
        }
        $buttonCode = '<p class="idosell_booking_cms_button_for_generate" data-clientid="' . $panelId .'" data-buttontext="' . $buttonText . '">' . JText::_('COM_IDOSELLBOOKINGWIDGET_TRWA_URUCHAMIANIE_SYSTEMU_REZERWACJI') . '</p>';
        return $buttonCode;
    }

    /**
     * generuje html przycisku bocznego
     *
     * @param array $buttonParams
     * @param bool $showAlternativeText
     * @param string $buttonText
     *
     * @return string
     */
    public function getSideButtonCode($buttonParams, $showAlternativeText = null, $buttonText = null)
    {
        $lang = JFactory::getLanguage();
        $lang->load('com_idosellbookingwidget', JPATH_ROOT);
        $panelId = $this->getIdoSellBookingWidgetSetting('booking_id');
        if (!$panelId) {
            return JText::_( 'COM_IDOSELLBOOKINGWIDGET_NIE_OKRESLONO_ID_PANELU' );
        }
        if (!$showAlternativeText) {
            $buttonText = $this->getIdoSellBookingWidgetSetting('button_standard_text');
            if (!$buttonText) {
                return JText::_( 'COM_IDOSELLBOOKINGWIDGET_NIE_OKRESLONO_TEKSTU_WYSWIETLANEGO_NA_PRZYCISKU' );
            }
        } else {
            if (!$buttonText) {
                return JText::_( 'COM_IDOSELLBOOKINGWIDGET_NIE_OKRESLONO_TEKSTU_WLASNEGO_WYSWIETLANEGO_NA_PRZYCISKU' );
            }
        }
        $buttonCode = '<div class="idosell_booking_cms_side_button_for_generate" data-clientid="' . $panelId .'" data-buttonlocationhorizontal="' . $buttonParams['location1'] .'" data-buttonlocationvertical="' . $buttonParams['location2'] .'" data-buttonfloat="' . $buttonParams['float'] .'" data-buttontext="' . $buttonText . '"></div>';
        return $buttonCode;
    }

    /**
     * generuje html iframe wyswietlajacego widget
     *
     * @param bool $applyAlternativeWidgetWidth
     * @param $widgetWidth
     *
     * @return string
     */
    public function getWidgetCode($applyAlternativeWidgetWidth = null, $widgetWidth = null)
    {
        $lang = JFactory::getLanguage();
        $lang->load('com_idosellbookingwidget', JPATH_ROOT);
        $bookingId = $this->getIdoSellBookingWidgetSetting('booking_id');

        if (!$bookingId) {
            return JText::_( 'COM_IDOSELLBOOKINGWIDGET_NIE_OKRESLONO_ID_PANELU' );
        }

        if (!$applyAlternativeWidgetWidth) {
            $widgetWidth = $this->getIdoSellBookingWidgetSetting('widget_standard_width');
        } else {
            if (is_array($widgetWidth) && !in_array($widgetWidth, array(980,760,690,480))) {
                return JText::_( 'COM_IDOSELLBOOKINGWIDGET_NIEPRAWIDLOWO_OKRESLONA_SZEROKOSC_WIDGETU' );
            }
        }

        $bookingId = $this->getIdoSellBookingWidgetSetting('booking_id');
        $widgetCode = '<p class="idosell_booking_cms_widget_for_generate" data-clientid="' . $bookingId .'" data-widgetwidth="' . $widgetWidth . '">' . JText::_('COM_IDOSELLBOOKINGWIDGET_TRWA_URUCHAMIANIE_SYSTEMU_REZERWACJI') . '</p>';
        return $widgetCode;
    }
}