<?php
/*
 * @license     GPLv2 or later http://www.gnu.org/licenses/gpl-2.0.html
 */
defined('_JEXEC') or die('Restricted access');

/**
 * Class IdoSellBookingWidgetModelHome
 *
 * klasa obslugujaca panel administracyjny
 */
class IdoSellBookingWidgetModelHome extends JModelAdmin
{
    public function getForm($data = array(), $loadData = true)
    {
        $form = $this->loadForm(
            'com_idosellbookingwidget.settings',
            'settings',
            array(
                'control' => 'jform',
                'load_data' => $loadData
            )
        );
 
        if (empty($form)) {
            return false;
        }
 
        return $form;
    }
 
    /**
     * laduje ustawienia do forumlarza
     */
    protected function loadFormData()
    {
        $data = JFactory::getApplication()->getUserState(
            'com_idosellbookingwidget.edit.settings.data',
            array()
        );
 
        if (empty($data)) {
            $data = $this->getItem();
        }
 
        return $data;
    }

    /**
     * zapisuje ustawienia
     */
    public function saveSettings() {
        $jinput = JFactory::getApplication()->input;
        $data  = $jinput->post->get('jform', array(), 'array');

        $name = new stdClass();
        $name->name = 'booking_id';
        $name->value = $data['booking_id'];

        $standardTextSetting = new stdClass();
        $standardTextSetting->name = 'button_standard_text';
        $standardTextSetting->value = $data['button_standard_text'];

        $standardWidthSetting = new stdClass();
        $standardWidthSetting->name = 'widget_standard_width';
        $standardWidthSetting->value = $data['widget_standard_width'];

        $demoSetting = new stdClass();
        $demoSetting->name = 'show_booking_demo';
        $demoSetting->value = $data['show_booking_demo'];

        $db = JFactory::getDbo();
        $db->updateObject('#__idosellbookingwidget_settings', $name, 'name');
        $db->updateObject('#__idosellbookingwidget_settings', $standardTextSetting, 'name');
        $db->updateObject('#__idosellbookingwidget_settings', $standardWidthSetting, 'name');
        $db->updateObject('#__idosellbookingwidget_settings', $demoSetting, 'name');

        JFactory::getApplication()->enqueueMessage('Zapisano ustawienia');
        return true;
    }

    /**
     * laduje ustawienia dodatku
     */
    public function getItem ($pk = null) {
        $settings = new JObject;
        $db = JFactory::getDbo();
        $query = $db->getQuery(true)
            ->select($db->quoteName(array('name', 'value')))
            ->from($db->quoteName('#__idosellbookingwidget_settings'));
        $db->setQuery($query);

        $row = $db->loadAssocList('name', 'value');
        $settings->set('booking_id', $row['booking_id']);
        $settings->set('button_standard_text', $row['button_standard_text']);
        $settings->set('widget_standard_width', $row['widget_standard_width']);
        $settings->set('show_booking_demo', $row['show_booking_demo']);
        return $settings;
    }
}